﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Student
{
    public partial class UCTabStudentDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School> _dictionarySchool = null;

        private PI.FM.N001.Account.BL.Account _blAccount = null;

        protected PI.FM.N001.Account.BL.Account BLAccount
        {
            get
            {
                if (_blAccount == null)
                {
                    _blAccount = new PI.FM.N001.Account.BL.Account(this.Environment);
                }
                return _blAccount;
            }
        }

        protected Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School> DictionarySchool
        {
            get
            {
                if (_dictionarySchool == null)
                {
                    _dictionarySchool = new Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School>(UCDetails.BLZSBELearning.School.Restore);
                }

                return _dictionarySchool;
            }
        }

        public UCTabStudentDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCStudentDetails UCDetails
        {
            get { return (UCStudentDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            UCDetails.DataManager.Bindings.Add(_gTextBoxSurename, "Surename", _gLabelSurename);
            UCDetails.DataManager.Bindings.Add(_gTextBoxForename, "Forename", _gLabelForename);
            UCDetails.DataManager.Bindings.Add(_gTextBoxEmail, "Email", _gLabelEmail);
            UCDetails.DataManager.Bindings.Add(_gTextBoxSchoolName, "SchoolName", _gLabelSchool);
            UCDetails.DataManager.Bindings.Add(_gTextBoxSchoolYear, "SchoolYear", _gLabelSchoolYear);
            UCDetails.DataManager.Bindings.Add(_gTextBoxClassName, "ClassName", _gLabelClassName);
        }

        public override void DoRestore()
        {
            if (UCDetails.DataManager.Current != null)
            {
                _gTextBoxInstructor.Text = String.Format("{0} {1}", UCDetails.DataManager.Current.InstructorSurename, UCDetails.DataManager.Current.InstructorForename);
            }
        }
    }
}
